library(DESeq2)
library(ggplot2)
library(ggrepel)
library(pheatmap)
args=commandArgs(T)
file <- args[1]
file1 <- args[2]
count.data <- read.csv(file,header = T)
exp.data <- count.data[,-1*1:6]
rownames(exp.data) <- count.data[,1]
colnames(exp.data) <- gsub(".R1.new.sam", "", colnames(exp.data))
mycounts <- exp.data
condition<- factor(c(rep("control1",2),rep("control2",2),rep("treat1",2),rep("treat2",2)))
colData <- data.frame(names = c("control-6h-1","control-6h-2","control-12h-1","control-12h-2","COVID-6h-1","COVID-6h-2","COVID-12h-1","COVID-12h-2"),condition)
rownames(colData) = colnames(mycounts)
dds <- DESeqDataSetFromMatrix(mycounts,colData ,design = ~condition)
keep <- rowSums(counts(dds))>=8
dds <- dds[keep,]
dds_norm <- DESeq(dds)


#rld <- rlog(dds)
#plotPCA(rld,intgroup=c("condition","names"))
#pcaData <- plotPCA(rld,intgroup=c("condition","names"),returnData=T)
#percentVar <- round(100*attr(pcaData,"percentVar"))
#pca <- ggplot(pcaData,aes(PC1,PC2,color=names,shape=condition))+geom_point(size=3)+ggtitle("DESeq2 PCA")+xlab(paste0("PC1:",percentVar[1],"% variance"))+ylab(paste0("PC2:", percentVar[2],"% variance"))+theme_bw()
#pca



mycounts <- exp.data[,c(1,2,5,6)]
condition<- factor(c(rep("control",2),rep("treat",2)))
colData <- data.frame(names = colnames(mycounts),condition)
rownames(colData) = colnames(mycounts)
dds <- DESeqDataSetFromMatrix(mycounts,colData ,design = ~condition)
keep <- rowSums(counts(dds))>=4
dds <- dds[keep,]
dds_norm <- DESeq(dds)

contrast <- c("condition","treat","control")
res <- results(dds_norm,contrast = contrast)
res$change <-  ifelse(res$padj <= 0.05& abs(res$log2FoldChange)>= 0.58, ifelse(res$log2FoldChange >=0.58 ,'Up','Down'), 'Stable')
res$name <- rownames(res)
res <- as.data.frame(res)
p <- ggplot(data = res, aes(x = log2FoldChange, y = -log10(padj), colour=change)) +geom_point() +scale_color_manual(values=c("blue", "grey","red"))+xlim(c(-7.5, 7.5)) +geom_vline(xintercept=c(-0.58,0.58),lty=4,col="black",lwd=0.6) +geom_hline(yintercept = -log10(0.05),lty=4,col="black",lwd=0.6) +labs(x="log2(fold change)",y="-log10 (padj)") +theme_bw()+theme(plot.title = element_text(hjust = 0.5), legend.position="right")+geom_text_repel(data=res[res$padj<=0.05&abs(res$log2FoldChange)>=0.58,],aes(label=name),size=3,segment.color="black",show.legend = F)+ylim(0,10)
p
covid6 <- p
pdf(file1,width=8,height=8)
covid6
dev.off()
res1 <- res



mycounts <- exp.data[,c(3,4,7,8)]
condition<- factor(c(rep("control",2),rep("treat",2)))
colData <- data.frame(names = colnames(mycounts),condition)
rownames(colData) = colnames(mycounts)
dds <- DESeqDataSetFromMatrix(mycounts,colData ,design = ~condition)
keep <- rowSums(counts(dds))>=4
dds <- dds[keep,]
dds_norm <- DESeq(dds)

contrast <- c("condition","treat","control")
res <- results(dds_norm,contrast = contrast)
res$change <-  ifelse(res$padj <= 0.05& abs(res$log2FoldChange)>= 0.58, ifelse(res$log2FoldChange >=0.58 ,'Up','Down'), 'Stable')
res$name <- rownames(res)
res <- as.data.frame(res)
p <- ggplot(data = res, aes(x = log2FoldChange, y = -log10(padj), colour=change)) +geom_point() +scale_color_manual(values=c("blue", "grey","red"))+xlim(c(-7.5, 7.5)) +geom_vline(xintercept=c(-0.58,0.58),lty=4,col="black",lwd=0.6) +geom_hline(yintercept = -log10(0.05),lty=4,col="black",lwd=0.6) +labs(x="log2(fold change)",y="-log10 (padj)") +theme_bw()+theme(plot.title = element_text(hjust = 0.5), legend.position="right")+geom_text_repel(data=res[res$padj<=0.05&abs(res$log2FoldChange)>=0.58,],aes(label=name),size=3,segment.color="black",show.legend = F)
p


b <- rownames(subset(res,res$padj<=0.05&abs(res$log2FoldChange)>=0.58))
a <- rownames(subset(res1,res1$padj<=0.05&abs(res1$log2FoldChange)>=0.58))
test <- append(a,b)
result1 <- exp.data[test,]
result2 <- res[test,c(2,6,7)]
result3 <- res1[test,c(2,6,7,8)]


condition<- factor(c(rep("control1",2),rep("control2",2),rep("treat1",2),rep("treat2",2)))
colData <- data.frame(names = c("control-6h-1","control-6h-2","control-12h-1","control-12h-2","COVID-6h-1","COVID-6h-2","COVID-12h-1","COVID-12h-2"),condition)
rownames(colData) = colnames(exp.data)
result1 <- result1[-30,c(1,2,5,6,3,4,7,8)]
choose_gene <- t(scale(t(result1)))
pdf(file1,width=8,height=8)
pheatmap(choose_gene,show_rownames = T,show_colnames = T,annotation_col = colData,cluster_cols = F,cluster_rows = T)
dev.off()
